// Stereo.POV 0.2 demo file.
// 
//  CAMERA TEST
//     by Ichthyostega
//                     
//     (c) Hermann Vosseler 2002
//         This scene may be used or redistributed 
//         for non-commercial purposes, provided
//         this copyright is kept intact.
//
/* ******************************
 * building blocks
 *   
 *   macros and elements used to
 *   build the structures. 
 *   
 *
 */
       
       // ____________________________________________________
      //  Elements for building the main Camera test structure.
     //


  // Vertical labeled Scale Tick
 //  fixed height
//
#macro vTick(pos,l)
  union{
     cylinder { <0, -1, 0>, <0, +1, 0>, 0.05 
               texture{element_tex_A translate pos } 
               texture{element_tex_B translate pos } 
              }
     text{ttf theFont, l, 0.02,0 pigment { colour 0.0 }  
          scale 0.2
          rotate -90*z
          translate 0.08*x -0.1*y
         }
        translate pos 
       }  
#end
    
    
  // Circle Line      
 //  centered at pos with given radius
//
#macro Kreis(pos,rad)
  difference {
     cylinder {-0.01*y, 0.01*y, rad+0.05 }
     cylinder {-0.1*y,   0.1*y, rad-0.05 }
              texture{element_tex_A} 
              texture{element_tex_B} 
              translate pos
             }   
#end             
 
  // Infinite Line 
 //  through point in given direction
//
#macro Gerade(pos,dir)
  #local G = vnormalize(dir);
     cylinder {-1e10*G, +1e10*G, 0.05 
                element_texturing(pigment{white_paint})
                translate pos
              } 
#end             

 // glass stem
//   
#macro Glas_Stange(P,l)
  cylinder{P 
           P+l*y 
           0.03
           interior{glas}
           texture{ transparent }
  } 
#end             

 // glossy Sphere
//   color depending on position
#macro Kugel(P,r)
  sphere{P,r texture{ glanz
                 pigment {color P-0.3*y}}}
#end             






       // ________________________________________________
      //  Elements for building the mad city in background
     //


 
  // the glossy spheres
 //  all over the city
//    
#macro ball(P)
   sphere{P 0.12
          texture{glanz
                  pigment{colour rgb col2}}}
          
#end             


  // basic structure: 
 //  cubic construction element with spheres
//
#macro cubus(o,a)
  union{union{
        cylinder{0,o*y 0.05 }
        cylinder{0,o*y 0.05 translate a*x} 
        cylinder{0,o*y 0.05 translate a*z} 
        cylinder{0,o*y 0.05 translate a*(x+z)} 
             element_texturing(pigment{colour rgb col1})
             }          
        union{                       
        cylinder{0,a*x 0.05 }
        cylinder{0,a*x 0.05 translate a*z}
        cylinder{0,a*z 0.05 }
        cylinder{0,a*z 0.05 translate a*x}
             translate o*y
             element_texturing(pigment{colour rgb col1})  
             }
        union{     
        ball(0)
        ball(a*x)
        ball(a*z)
        ball(a*(x+z))
              translate o*y
             } 
        
  }
#end

  // 
 //  cubic elements stacked
//
#macro quad_stack(a,h)
  #local level = mod(h,a);
  #if (level+a < h)
     #local level = level + a;
     union{cubus(level,a)
           object{
           quad_stack(a,h-level)
           
           translate level*y
          }      }
  #else        
     cubus(h,a) 
  #end
  
#end

 // top of a tower of cubic elements
//
#macro quad_top(P,a,h)               
  #local len = sqrt(a*a/2+h*h); 
  #local ang = atan2(a/2,h)*180/pi+5;
  union{  union{cylinder{0, len*y 0.05 rotate ang*x+(45    )*y}
                cylinder{0, len*y 0.05 rotate ang*x+(45+90 )*y translate z  }
                cylinder{0, len*y 0.05 rotate ang*x+(45+180)*y translate z+x}
                cylinder{0, len*y 0.05 rotate ang*x+(45+270)*y translate   x}
                     element_texturing(pigment{colour rgb col1})
           
               }
          ball((x+z)/2+h*y)
        translate P
       } 
#end


   // __________
  //  The Clocks
 // 
//  Frame the clocks are mounted on

#macro clock_frame()
  #local d=0.15;
  #local bar     = box{(0-d/2)*x+d/2*(z+y), (1+d/2)*x-d/2*(z+y) }
  #local support = box{-d/2*z, x*sqrt(2)+d/2*z+d/4*y translate -d/2*y }
  union{
        object{bar }
        object{bar translate z}        
        object{bar rotate -90*y}
        object{bar rotate -90*y translate x}        
        
        object{support rotate -45*y            }
        object{support rotate +45*y translate z}

            element_texturing(pigment{colour rgb col1})
       }

#end
  


#macro pendulum(len)    
  #local radi = (.05+.1*len/1.5); 
  #local sin10 = 0.1736;
  #local b_rad = radi/sin10;
  #local offs  = b_rad - radi*sin10;
  union{cylinder{-len*y, 0, 0.02}   
        intersection{sphere{-offs*x,b_rad}
                     sphere{+offs*x,b_rad}   bounded_by{sphere{0,1.5*radi}}
                     translate -.7*len*y }
       }
#end
                              
#macro clock_weight(param)
    // 
   //  note: constructed upside-down
  #local w_diam = .03+.02*mod(param,13)/13;
  #local w_rad  = .05+.01*mod(param,14)/14;
  #local w_cnt  = 4 + mod(param,4);
  #local w_spc  = 0.01;
  #local w_len  = w_cnt*(w_diam+w_spc);
  
  union{union{
          #local i=0;
          #while (i<w_cnt)
              cylinder{0,w_diam*y, w_rad  translate i*(w_diam+w_spc)*y 
                                          clock_weight_tex(w_diam,i) }
              #local i=i+1;
          #end
             }
        union{cylinder{0,w_len*y  w_rad/3}
        
              cylinder{0,w_len*y, 0.01 translate w_rad*x}     
              cylinder{0,w_len*y, 0.01 translate w_rad*x rotate +y*120}
              cylinder{0,w_len*y, 0.01 translate w_rad*x rotate -y*120}
              
              cylinder{0,w_spc*y, w_diam+0.01 translate -w_spc/2*y      }
              cylinder{0,w_spc*y, w_diam+0.01 translate (w_len-w_spc)*y }
              
              box{-(x+z)*0.02, 0.05*z+(x+z)*0.02+y*0.01}
              box{-(x+z)*0.02, 0.05*z+(x+z)*0.02+y*0.01 translate w_len*y}
              
              texture{dull_tex pigment{colour rgb col2}}
             }
       }      
#end

#macro weight_system(len,param)
  #local l = len - len/2*mod(param,9)/9;
  union{chain(l)
        cylinder{0, 1.6*len*y, 0.01 translate 0.05*z
                                    texture{dull_tex
                                            pigment{dial_black}}}
        object{clock_weight(param)    
               translate l*y }
        rotate x*180
       }
#end

  //
 //  the clockwork 
//
#macro clock_work(param,clock_val, time)
    //
   #local rythm = time*60*60 * 2*siz;
   #local d     = 2/3*clock_val/6*(1+mod(param,5)/50);   // dimensions of case
   #local w_cnt = div(clock_val,2);                     //  no. of weights
   #local p_len = 1.5*(mod(param,6)+3)/8;              //   length of pendulum
   
   union{difference{box{0, d*(x+z)+3/4*d*y           // cut holes for the 
                        translate 0.01*y  }         //  devices hanging below
                    box{-.1*z <0.05,d/2,0.1> translate d/2*z+4/5*d*x}
                 #local i=1;
                 #while (i<=w_cnt)
                    cylinder{0, d/2*y,0.03 translate 0.1*x + i*d/(w_cnt+2)*z}
                   #local i=i+1;
                 #end
                                           
                    dull_textured(col1)
                   } 
                     
         object{pendulum(p_len)
                rotate sin(rythm*2*pi)*10*x
                translate d/2*z+(4/5*d+0.025)*x +0.1*y
                texture{ pendulum_tex }
               }
        
       #local i=1;
       #while (i<=w_cnt)
         object{weight_system(p_len,i*param)
                translate 0.1*x + i*d/(w_cnt+2)*z
               }
         #local i=i+1;
       #end
        
         translate -d/2*(x+z)                
        }
#end


  //
 //  one dial of clock
//
#macro clock_dial(diameter, time, s1,s2)
                // centered at origin 
               // looking in -z direction
              //  given diameter and size values s1,s2
             //   time is counted in hours p.m.
             #local minutes = (time-floor(time))*60;
             #local hour_turn =time/12 * 360;
             #local min_turn  =time    * 360;
             #local rad = diameter/2;  
             #local std_off = 0.075; // offset in outward direction
             
             #local pointer = prism{linear_sweep linear_spline
                                    0,0.01,
                                    12, 
                                    <0,-1>, <-1,0>, <-1,3>, <0,12>, <1,3>, <1,0>, <0,-1> 
                                    <0,-1>, <1,-3> <0,-4>, <-1,-3>, <0,-1>
                                    scale <1/12,1,1/12>
                                    rotate -90*x
                                   } 

             
             union{difference{cylinder{       0,-z*0.01,    s1*rad}
                              cylinder{-z*0.005,-z*0.011, 0.85*rad}
             
                              texture{dull_tex_A
                                      pigment{dial_white}
                                      finish{brilliance 0.3
                                             metallic      
                                     }      } 
                             }        
                                      
                   cylinder{-z*0.005,-z*0.009, 0.75*rad
                            texture{clock_dial_tex
                                    pigment{dial_white}}
                           }
                   cylinder{-z*0.005,-z*0.011, 0.05+0.1*rad
                            texture{clock_dial_tex
                                        pigment{dial_black}}}
                   sphere{-z*0.008,0.005
                            texture{clock_dial_tex
                                        pigment{colour rgb col1 }}}
                   cylinder{0,       -z*0.015, 0.01+0.1*rad
                            texture{element_tex_A
                                        pigment{dial_black}}}
                                        
                   object{pointer
                          scale <rad/s1, 0.8*s2*rad, 1>
                          rotate -min_turn*z
                          translate -0.014*z
                            texture{element_tex_A
                                        pigment{colour rgb col2}}}
                   object{pointer
                          scale <rad/s1, 0.6*s2*rad, 1>
                          rotate -hour_turn*z
                          translate -0.013*z
                            texture{element_tex_A
                                        pigment{colour rgb col2}}}
                                        
             #local i=0;                                        
             #while (i<12)
                   #if (mod(i,3) < 0.1)
                      #local tick_len = 0.2*rad;
                   #else
                      #local tick_len = 0.09*rad;
                   #end
                   box{<-rad/24, 0,0>  <+rad/24,-tick_len,-0.012>
                       translate s2*0.7*rad*y
                       rotate 30*z*i
                            texture{element_tex_A
                                        pigment{colour rgb col2}}}
                             
                   #local i=i+1;
             #end
                                        

                     
                                        
                   translate -std_off*z
                  }
#end


  //
 //  setup clock on tower
//
#macro create_clock(level, siz,value, clock_val)
   #local num_dials = div(clock_val+1/2,2);
   #local c____time = global_time + value/60 - vlength(level)*siz;
   union{    
         object{clock_frame()
                translate y/2
               } 
         object{clock_work(vlength(level)*value, clock_val, c____time)
                rotate value*90*y
                translate y*(1/4) + (x+z)/2
               } 
            
           // setup an irrecular count of dials   
          //  on the four sides of the tower   
         #local i=0;
         #local dc = clock_val;
         #local cutoff = 2*value*vlength(level);
         #while (i<num_dials)// for all dial-locations at one side
           #local j=0;
           #while (j<4)     // for all four sides
             #local j=j+1;
             #if (dc < cutoff & mod(dc,6)<(clock_val+1))
                #local offs=-x/2+x/num_dials*(i+1/2);  // pick place of dial on one side 
                #local turn=vrotate(-z/2+offs,j*90*y);//  turn it round to apropriate side
                #local center= (x+z)/2 + y/2;

                object{clock_dial(1/num_dials,c____time,0.95+0.25*clock_val/6,           
                                                        1/(1-0.3*1/vlength(level)))
                       rotate j*90*y
                       translate center + turn 
                      }   
                union{cylinder{vrotate(-z/4, j*90*y),    0, 0.02}  // mechanical connection
                      cylinder{vrotate(-z/4, j*90*y), turn, 0.02} // beteween dial and clockwork
                      texture{dull_tex pigment{dial_black}}
                      translate center
                     } 
                
             #end
             #local dc=dc+value;
           #end
           #local i=i+1;
         #end
         
         translate level
        }
#end




  
  // ________________
 //  platform/gangway
//
#macro panel(P, q, w)          // P on middle axis
                              //  q-Vect. points half in length direction
                             //   w-Vect. points forward and gives with of panel
  #local p0 =P-q;           // Edges of         
  #local p1 =P+q+w+0.05*y; //  the box         (thickness fixed to 5cm)       
  
  #local yw = vlength(w)*y;
  #local q0 = vnormalize(q);
                                       
  #local r0 = vaxis_rotate(w,-q, +45);    // to make bevels                
  #local r1 = vaxis_rotate(w,-q, -45);
  #local r2 = vaxis_rotate(w,-q, +45+180);
  #local r3 = vaxis_rotate(w,-q, -45+180);
  
  #local c0 = p0     +q0*0.1; // pos. of screws
  #local c1 = p0+2*q -q0*0.1; // pos. of screws
  
  union{difference{box{p0,p1}
                              // 5% beveled edges
                   plane{r0,0 translate p0+0.05*w            }
                   plane{r1,0 translate p0-0.05*yw   +0.05*y }
                   plane{r2,0 translate p0-0.05*w  +w+0.05*y }
                   plane{r3,0 translate p0+0.05*yw +w        }
                   
                            // holes for the screws
                   cylinder{c0+0.25*w, c0+0.25*w+0.06*y 0.02} // 4cm diameter
                   cylinder{c0+0.75*w, c0+0.75*w+0.06*y 0.02}

                   cylinder{c1+0.25*w, c1+0.25*w+0.06*y 0.02}
                   cylinder{c1+0.75*w, c1+0.75*w+0.06*y 0.02}
                   
                   bounded_by{box{p0,p1}}
   
                   panel_texture(P, vlength(w),0.05)
                  } 
                   
                    
        union{      // the screws      
           cylinder{c0+0.25*w, c0+0.25*w+0.055*y 0.012}
           cylinder{c0+0.75*w, c0+0.75*w+0.055*y 0.012}

           cylinder{c1+0.25*w, c1+0.25*w+0.055*y 0.012}
           cylinder{c1+0.75*w, c1+0.75*w+0.055*y 0.012}
              texture{ glanz }
              pigment{colour rgb col1}
             }
       }
       
  
#end
#macro platform(P,dir,w) 
  #local row_width = 1;
  #local row_cnt = max(1, floor(w/row_width)); // only one implemented at the moment...
  #local row_width = w/row_cnt;
  
  #local dist = vlength(dir);
  #if (dist > 0)
          #local panel_width = 0.09;
          #local panel_spacing = 0.015;
          #local panel_cnt = floor(dist/(panel_width+panel_spacing));
          #local panel_width = dist/panel_cnt - panel_spacing;
          
          #local q = vnormalize(vcross(y,dir));
          #local l = vnormalize(dir);

          #local s0 = 0  -0.01*l;
          #local sd = dir+0.01*l;          
          union{cylinder{s0 sd 0.03                     // the supports
                         texture{ element_tex_A }
                         translate (-w/2 +0.1)*q }      // offset 10cm towards middle axis
                cylinder{s0 sd 0.03
                         texture{ element_tex_A }
                         translate (+w/2 -0.1)*q }
                         
              #local i=0;                          
              #while (i<panel_cnt)
                panel(0.013*y + i*(panel_width+panel_spacing)*l, q*w/2, panel_width*l)
                #local i = i+1;
              #end
                      
               translate P
               }        
  #end     
#end

  // sort of gangway 
 //  to connect the elements
//
#macro platform_conect(from, to, w)
   #local dir = to-from;
   #if (abs(dir.x) > abs(dir.z))  
      platform(from -w/2      *x, dir.x*x, w)
      platform(to -(w/2+dir.z)*z, dir.z*z, w)
   #else
      platform(from -w/2      *z, dir.z*z, w)
      platform(to -(w/2+dir.x)*x, dir.x*x, w)
   #end
#end






  // ___________________________________________
 //  three main parametrisizable building blocks
//
#macro b1(pos,col1,col2,siz,value)
        union{
              quad_stack(1,5*siz)        
              
              #local cBox   = box{0-0.05, x+z+y/sqrt(2)+0.05}
              #local Schale = difference{sphere{(x+z)/2, 1/sqrt(2)+0.05}
                                         sphere{(x+z)/2, 1/sqrt(2)-0.04}
                                        }
              #local domeShell = intersection{object{cBox}
                                              object{Schale}
                                             bounded_by{cBox}
                                             clipped_by{bounded_by}
                                             } 
              #local sliceCut  = box{0 <2,1,0.1> translate -0.05}

              intersection{object{domeShell}
                           union{object{sliceCut  rotate -45*y}
                                 object{sliceCut  rotate +45*y translate z}
                                } 
                           
                           bounded_by{cBox}
                           clipped_by{bounded_by}

                       element_texturing(pigment{colour rgb col1})
                       
                translate +siz*5*y     
              }
              object{ball(0)                         
                     //scale 2
                     translate 0.5*(x+z)  +(siz*5+1/sqrt(2))*y
                    } 
         translate pos
        }

#end
#macro b2(pos,col1,col2,siz,value)
        union{           
              union{object{quad_stack(1, 10*siz)}
                    object{quad_stack(1, 6*siz)
                           rotate 90*x
                           translate 10*siz*y+z
                          }          
                    scale 0.5
                    pigment{colour rgb col1}      
                   }
          sphere {0,0.001 pigment{dial_white}}
         #if (mod(value,5) < 0.1 )
          #debug "ding-ding\n"
         #end              

         translate -0.5*(x+z)
         rotate mod(3*value,4)*90*y
         translate +0.5*(x+z)
         translate pos
        }
        
        #local conect_to = pos+(x+z)/2 + vrotate((x+z)/4, mod(3*value,4)*90*y);
        #ifdef (conect_start)
          #if (vlength(conect_to-conect_start) < 5 )
             // it's near enough,
            // create conecting platform/gangway
            platform_conect(conect_start,conect_to,0.5)
          #end
        #end
        #declare conect_start=conect_to;

#end
#macro b3(pos,col1,col2,siz,value)
         #local tower_height=siz*8*value;
         #switch (mod(value,5))    
           #range (0,0.1)  #local top_height = 3;
                           #break
           #range (3,4)    #local top_height = 1.2;
                           #break
           #else           #local top_height = 0.5;
         #end              
         #local has_clock=false;
         #local clock_val = mod(siz*41*value,7);
         #if (clock_val >= 2 & clock_val <=6)
            #local has_clock = true;
            #local clock_off = siz*(7-clock_val);
            #local clock_cnt = floor(tower_height / (clock_off+2));
         #end
         
        union{        
              #local h = floor(value/3);
              #if (h>0)
              union{object{quad_stack(1,h)}
                    object{quad_stack(1,1/2)
                           rotate -90*z
                           translate x+h*y
                          } 
                       
                    scale 2/3
                    translate z/3
                   }
              #else
              ball(-y) // dummy placeholder     
              #end     
              union{union{quad_stack(1, tower_height)
                          quad_top(tower_height*y,1, top_height) 
                          #if (has_clock)
                            #debug "tick-tack\n"  

                            #local i=0;
                            #local clock_level=tower_height-1;
                            #while (i<clock_cnt)                 
                                  #local clock_level=clock_level-clock_off;
                                  
                                  create_clock(clock_level*y, siz,value,clock_val)

                                  #local clock_level=clock_level-2; 
                                  #local i=i+1;     
                            #end
                          #else
                            #debug "(silent)\n"
                            ball(-y)
                          #end
                          scale 0.5
                         } 
                    platform(z/4-x/4, x, 0.48)
 
                  
                    translate -(x+z)/4
                    translate vrotate(x/4, value*40*y)
                    translate +(x+z)/2
                   }          
                      
         translate pos
        }
#end

