// Stereo.POV 0.2 demo file.
// 
//  building blocks macro include 
//     by Ichthyostega
//                     
//     (c) Hermann Vosseler 2002
//         This scene may be used or redistributed 
//         for non-commercial purposes, provided
//         this copyright is kept intact.
//
/* ******************************
 * Creates a "regular clutter" of 
 * parametrisizsable building blocks.
 * They are snaped together to build up
 * larger structures.
 *   
 * Note: the three basic building block types
 *       "b1", "b2" and "b3"
 *       need to be alredy declared.
 *
 */
 
 

  // -----------generic-functions------------
 // Stacks of anchor points
//
#declare anchor_cnt = 100;
#declare num_families = 2;  
#declare pos_Stack = array[anchor_cnt*num_families]
#declare col_Stack = array[anchor_cnt*num_families]
#declare siz_Stack = array[anchor_cnt*num_families]
#declare val_Stack = array[anchor_cnt*num_families]
#declare last_anc = 0;

#declare a_family       = array[num_families][anchor_cnt]
#declare first_family_a = array[num_families]
#declare last_family_a  = array[num_families]
#declare pos_offset     = array[num_families]

// init stacks
#local i=0;
#while (i<num_families)
  #declare first_family_a[i] = 0;
  #declare last_family_a[i] = 0;
  #declare i=i+1;
#end  
                              
#macro anchor_pt_family(nr)
  #declare a_family[nr][last_family_a[nr]] = last_anc;
  #declare last_family_a[nr] = last_family_a[nr] + 1;
#end
                              
#macro anchor_pt(pos,col,siz,value)
  #declare pos_Stack[last_anc] = pos;
  #declare col_Stack[last_anc] = col;
  #declare siz_Stack[last_anc] = siz;
  #declare val_Stack[last_anc] = value;
  
  #declare last_anc = last_anc+1;
#end

#macro anchor_to(anchor_id)   
  #declare pos  = pos_Stack[anchor_id];
  #declare col  = col_Stack[anchor_id];
  #declare siz  = siz_Stack[anchor_id];
  #declare value= val_Stack[anchor_id];
#end               

#macro take_fam_first(fam_id)
  #local id = a_family[fam_id][first_family_a[fam_id]];
  #declare first_family_a[fam_id] = first_family_a[fam_id] + 1;
  anchor_to(id)
#end           


#macro has_free(fam_id)
  (last_family_a[fam_id] - first_family_a[fam_id])
#end

#declare pos_offset[0] = x;
#declare pos_offset[1] = z;    
#macro pos_inc(pos,family)
  #declare pos = pos + pos_offset[family];
#end    


  // -----------building-the-structure-------
 //
//

#macro create_seq(fam,pos,col,siz,value)
   #local p = pos;
   pos_inc(p,fam)
   anchor_pt_family(fam)
   anchor_pt(p,col,siz,value)
   #if (siz > 0.1)
     create_seq(fam,p,0.85*col+0.14*z,0.9*siz,value+1)
   #end
#end

#macro setup_cells(fam,num,col2)
   #local i = num;
   #while (has_free(fam) & i > 0)
     take_fam_first(fam)
     #switch (mod(num,3))  // three basic types of cells
       #range(0,1)
          b1(pos,col,col2,siz,value)
          #break
       #range(1,2)
          b2(pos,col,col2,siz,value)
          #break
       #range(2,3)
          b3(pos,col,col2,siz,value)
          #break
     #end
     #local i = i-1;     
   #end
#end

  
  // Step in diagonal, create rows/colums of anchor points. 
 //  When stepping back, set cells to the anchor points.
//    
#macro step_in_main(pos,col,siz,value)
   create_seq(0,pos,col,siz*value,value)
   create_seq(1,pos,col,siz*value,value)
   pos_inc(pos,0)
   pos_inc(pos,1)
   #local c = vaxis_rotate(col,z,5)+0.05*z;
   #local s = siz * 0.6;
   #if (value < 7)
     step_in_main(pos,c,s,value+1)
   #end
   setup_cells(0,1.2*value,c) 
   setup_cells(1,0.8*value,c)
#end
