// Stereo.POV 0.2 demo file.
// 
//  CAMERA TEST
//     by Ichthyostega
//                     
//     (c) Hermann Vosseler 2002
//         This scene may be used or redistributed 
//         for non-commercial purposes, provided
//         this copyright is kept intact.
//
/* ******************************
 * main scene file
 *   
 *    inspired by POV-ray's camera test scene.
 *   Somewhat of a desert scene with geometrical structures,
 *   angle and depth marks and lines going off to infinity.
 *
 *   It's a strange place.
 *   And in the background, there is....  (try it out!)
 *
 */


#version unofficial stereopov 0.2;


// --------------------------------------------CONFIGURE THIS
#declare theFont = "C:\\WINDOWS\\FONTS\\cour.ttf"
// -------------------------------------------/CONFIGURE THIS


#include "decl.inc"
#include "construct.inc"
#include "elements.inc"

global_settings { assumed_gamma 2.2 
                  ambient_light rgb<1.1,1.0.999> 
                }

#declare global_time= -1.8;      // time for the clocks




#declare camera_at_origin = camera {location 0
                                    direction z
                                    right x*4/3
                                    up y
                                    angle 90
                                    stereo_base 0.065
                                    cross_eyed
                                   }
#declare main_view_cam    = camera {camera_at_origin
                                    translate -2*z
                                   }
                                   
#declare general_view_cam = camera {orthographic
                                    location 0
                                    up 4*y
                                    right 4*x*4/3
                                    direction 4*z
                                    translate -4*z -0.5*y
                                    rotate 20*x + 45*y 
                                    translate 1*y
                                    window_distance 4
                                    cross_eyed
                                   }




camera {camera_at_origin}




// the sky  
sphere{ -y, 100000 hollow

        texture{
                pigment{gradient y 
                        colour_map {[0.07  color rgb<0.040,0.250,0.400>   ]
                                    [0.20 color rgb<0.034,0.160,0.340>   ] 
                                    [0.45 color rgb<0.026,0.120,0.251>*1.1] 
                                    [0.80 color rgb<0.026,0.120,0.251>*.8]
                                   } 
                        scale 100000
                       }                       
                finish{ambient 0.4
                       diffuse 1
                       phong .1
                       phong_size 10}
                }
               
        texture{pigment{gradient -z 
                        colour_map {[0.5  color rgbt<0,0,0,1>]
                                    [0.97 color rgbf<0.93,0.98,1,0.88>] 
                                    [0.995 color rgbf<0.97,0.98,0.9,0.85>] 
                                   } 
                        scale 200000
                        translate 100000*z
                        rotate 30*x-45*y
                       }
               }                               
}  


// the sun 
light_source{ <40000, 40000, -40000> color 1.1 }


light_source{ <-100, 10, 20> 
              color rgb<0.9,0.88,0.6>*1/3 
              shadowless
            }
            

light_source{ <80, 500, -100> color rgb<0.4,0.42,0.74>
              spotlight point_at <60,-80,0>
                        radius 6.5
                        falloff 7.02
                        tightness 65
              area_light 50*x,50*y, 6,6
              adaptive 1
              jitter
            }  


// Ground Plane
plane
{
  y, -1.0
  texture { boden } 
}
  

    
  //---------------------------------------------------------
 //
//
// horizontal circles in different heights
Kreis(-y,1)   
Kreis(0.5*y,1)
Kreis(y,1)
Kreis(1.5*y,1)
Kreis(2*y,1)    

// tangents on the circle at ground level
Gerade(<0,-1,1>,x)
Gerade(<0,-1,-1>,x)
Gerade(<1,-1,0>,z)
Gerade(<-1,-1,0>,z)


#declare dist=2;
 #while (dist < 1000)  
  object{vTick(<-1,-0.6,dist>,str(dist,1,0))      //  vertical scale tick labeled with distance
  }
        
  #declare dist=dist+1;
 #end              


  // circular Struktur 
 //   30 deg. angular steps
//              
  
#declare Winkel=0;
 #while (Winkel < 360)  
   #declare P=vaxis_rotate(z,y,Winkel);
  Gerade(-y, P)                         // radial Line to infinity
  object{vTick(y,str(Winkel,1,0))      //  vertical scale tick labeled with angle
     rotate Winkel*y
     translate P
  }
  #declare hoch=0;
  #while (hoch < 10)                   //  10 stacked Spheres
    Kugel(P+(hoch +0.25)*y,0.2)      
    #declare hoch = hoch + 1;
  #end      
  Glas_Stange(P+2*y,7)     
  #declare P=vaxis_rotate(z-y,y,Winkel+15);
  Glas_Stange(P,1.5)
        
  #declare Winkel=Winkel+30;
 #end              




   // ------------------------------------------------------              
  //  in "background" we see strange things...
 //
//
#declare pos   = <2,-1,1>;
#declare col   = <1.2,0.2,0>;
#declare siz   = 0.2;
#declare value = 1;

step_in_main(pos,col,siz,value)

b3(<11,-1,-2>,<0.026,0.120,0.251>,<0.040,0.250,0.400>,.4,2)

